/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.domain.globalsetting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tp_link.eap.util.c;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Range;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="setting")
public class PortalSetting {
    @Id
    private String id;
    @Transient
    private Integer index;
    @Pattern(regexp="^$|.{1,31}", message="Length of Portal Name is from 1 to 31")
    private String portalName;
    private String authType;
    @Range(min=0L, max=4L, message="Value of 'Authentication Timeout' is from 0 to 4.")
    private Integer authTimeout;
    @Range(min=0L, max=29L, message="Value of Day is from 0 to 29.")
    private Integer portalDay = 0;
    @Range(min=0L, max=23L, message="Value of Hour is from 0 to 23.")
    private Integer portalHour = 0;
    @Range(min=0L, max=59L, message="Value of Minute is from 0 to 59.")
    private Integer portalMin = 1;
    private Long authDuration;
    private Boolean dailyLimitEnable;
    private Boolean httpsRedirectEnable;
    private Boolean redirectEnable;
    private String redirectUrl;
    private String customizatoion;
    private String externalPortalUrl;
    @Pattern(regexp="^$|.{1,31}", message="Length of Username is from 1 to 31.")
    private String userName;
    @Pattern(regexp="^$|.{1,31}", message="Length of Password is from 1 to 31.")
    private String password;
    @Pattern(regexp="^$|\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Value of Radius Server Ip should be correct ip address.")
    private String radiusServerIp;
    private String radiusPassword;
    @Range(min=0L, max=65535L, message="Value of Radius Port is form 0 to 65535.")
    private Integer port;
    private String rmtPortalUrl;
    @Pattern(regexp="^$|.{1,31}", message="Length of Login Title is from 1 to 31.")
    private String portalTitle;
    private Boolean termsEnable;
    private String portalUseTerm;
    private Boolean portalAccept = true;
    private String externalPortalServer;
    private String twilioSid;
    private String twilioAuthToken;
    private String phoneNumber;
    @Range(min=0L, max=10L, message="Value of max user is from 0 to 10.")
    private Integer maxUser;
    @Pattern(regexp="^$|\\+(93|374|994|973|880|975|673|855|86|670|995|852|91|62|98|964|972|81|962|850|82|965|996|856|961|853|60|960|976|95|977|968|92|970|63|974|7|966|65|94|963|886|992|66|90|90|993|971|998|84|967|355|376|43|375|32|387|359|3491|385|357|420|45|372|298|358|33|49|350|30|36|354|353|39|371|423|370|352|389|356|373|377|382|31|47|48|351|40|378|381|421|386|34|46|41|380|44|379|213|244|229|267|226|257|237|3491|238|236|235|269|242|243|253|20|240|291|251|241|220|233|224|245|225|254|266|231|218|261|265|223|222|230|212|258|264|227|234|262|250|239|221|248|232|252|27|211|34|249|268|255|228|216|256|260|263|1684|61|682|679|689|1671|692|691|687|64|1670|680|675|685|677|676|688|678|1684|1264|1268|297|247|1|1246|501|1441|1|1345|506|53|1767|1809|1809201|503|299|1473|590|1671|502|509|504|1876|596|52|1664|599|505|1670|507|1787|1869|1758|508|1784|1868|1649|1|1284|1340|54|591|55|56|57|593|500|594|592|595|51|597|598|58|883)", message="Invalid country code.")
    private String countryCode;
    private String backgroundPath = "/theme/img/portal/background.jpg";
    private String logoPath = "/theme/img/portal/portalLogo_picture@2x.png";
    @Transient
    private String advertiseImgPath;
    @Indexed
    private String site;
    @Indexed
    private String key = "portal";
    @Transient
    private List<String> selectedSsid;
    @Indexed
    private int templateType;
    private int backgroundMode;
    private String backgroundPictureId;
    private String backgroundColor;
    private String logoPictureId;
    private int logoPosition;
    private String welcomeInfo;
    private String welcomeColor;
    private String copyrightInfo;
    private String copyrightColor;
    private String inputBoxColor;
    private int buttonPosition;
    private String buttonColor;
    private String buttonTextColor;
    private boolean adEnable;
    private int adPictureMode;
    private List<String> adPictureIdList;
    private List<String> adPictureIdArray;
    private int adDurationTime;
    private int adPictureCarouselInterval;
    private boolean allowSkip;
    private String gwId;
    private String gwSecret;
    private String pageId;
    private String pageName;
    private List<String> freeAuthPolicyIdList;

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAdvertiseImgPath() {
        return this.advertiseImgPath;
    }

    public void setAdvertiseImgPath(String advertiseImgPath) {
        this.advertiseImgPath = advertiseImgPath;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getAuthTimeout() {
        return this.authTimeout;
    }

    public void setAuthTimeout(Integer authTimeout) {
        this.authTimeout = authTimeout;
    }

    public Boolean getRedirectEnable() {
        return this.redirectEnable;
    }

    public Integer getPortalDay() {
        return this.portalDay;
    }

    public void setPortalDay(Integer portalDay) {
        this.portalDay = portalDay;
    }

    public Integer getPortalHour() {
        return this.portalHour;
    }

    public void setPortalHour(Integer portalHour) {
        this.portalHour = portalHour;
    }

    public Integer getPortalMin() {
        return this.portalMin;
    }

    public void setPortalMin(Integer portalMin) {
        this.portalMin = portalMin;
    }

    public Boolean getDailyLimitEnable() {
        return this.dailyLimitEnable;
    }

    public void setDailyLimitEnable(Boolean dailyLimitEnable) {
        this.dailyLimitEnable = dailyLimitEnable;
    }

    public String getPortalTitle() {
        return this.portalTitle;
    }

    public void setPortalTitle(String portalTitle) {
        this.portalTitle = portalTitle;
    }

    public Boolean getTermsEnable() {
        return this.termsEnable;
    }

    public void setTermsEnable(Boolean termsEnable) {
        this.termsEnable = termsEnable;
    }

    public String getPortalUseTerm() {
        return this.portalUseTerm;
    }

    public void setPortalUseTerm(String portalUseTerm) {
        this.portalUseTerm = portalUseTerm;
    }

    public Boolean getPortalAccept() {
        return this.portalAccept;
    }

    public void setPortalAccept(Boolean portalAccept) {
        this.portalAccept = portalAccept;
    }

    public void setRedirectEnable(Boolean redirectEnable) {
        this.redirectEnable = redirectEnable;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getExternalPortalUrl() {
        return this.externalPortalUrl;
    }

    public void setExternalPortalUrl(String externalPortalUrl) {
        this.externalPortalUrl = externalPortalUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setGuestPassword(String password) {
        this.password = password;
    }

    public String getRadiusServerIp() {
        return this.radiusServerIp;
    }

    public void setRadiusServerIp(String radiusServerIp) {
        this.radiusServerIp = radiusServerIp;
    }

    public String getRadiusPassword() {
        return c.d(this.radiusPassword);
    }

    public void setRadiusPassword(String radiusPassword) {
        this.radiusPassword = c.c(radiusPassword);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getRmtPortalUrl() {
        return this.rmtPortalUrl;
    }

    public void setRmtPortalUrl(String rmtPortalUrl) {
        this.rmtPortalUrl = rmtPortalUrl;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExternalPortalServer() {
        return this.externalPortalServer;
    }

    public void setExternalPortalServer(String externalPortalServer) {
        this.externalPortalServer = externalPortalServer;
    }

    public Long getAuthDuration() {
        return this.authDuration;
    }

    public void setAuthDuration(Long authDuration) {
        this.authDuration = authDuration;
    }

    public String getBackgroundPath() {
        return this.backgroundPath;
    }

    public void setBackgroundPath(String backgroundPath) {
        this.backgroundPath = backgroundPath;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getCustomizatoion() {
        return this.customizatoion;
    }

    public void setCustomizatoion(String customizatoion) {
        this.customizatoion = customizatoion;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return "PortalSetting{id='" + this.id + '\'' + ", authType='" + this.authType + '\'' + ", authTimeout=" + this.authTimeout + ", portalDay=" + this.portalDay + ", portalHour=" + this.portalHour + ", portalMin=" + this.portalMin + ", authDuration=" + this.authDuration + ", redirectEnable=" + this.redirectEnable + ", redirectUrl='" + this.redirectUrl + '\'' + ", customizatoion='" + this.customizatoion + '\'' + ", externalPortalUrl='" + this.externalPortalUrl + '\'' + ", userName='" + this.userName + '\'' + ", password='" + this.password + '\'' + ", radiusServerIp='" + this.radiusServerIp + '\'' + ", radiusPassword='" + this.radiusPassword + '\'' + ", port=" + this.port + ", rmtPortalUrl='" + this.rmtPortalUrl + '\'' + ", portalTitle='" + this.portalTitle + '\'' + ", portalUseTerm='" + this.portalUseTerm + '\'' + ", portalAccept=" + this.portalAccept + ", externalPortalServer='" + this.externalPortalServer + '\'' + ", backgroundPath='" + this.backgroundPath + '\'' + ", logoPath='" + this.logoPath + '\'' + ", advertiseImgPath='" + this.advertiseImgPath + '\'' + ", site='" + this.site + '\'' + ", key='" + this.key + '\'' + '}';
    }

    public String getPortalName() {
        return this.portalName;
    }

    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    public int getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(int templateType) {
        this.templateType = templateType;
    }

    public int getBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(int backgroundMode) {
        this.backgroundMode = backgroundMode;
    }

    public String getBackgroundPictureId() {
        return this.backgroundPictureId;
    }

    public void setBackgroundPictureId(String backgroundPictureId) {
        this.backgroundPictureId = backgroundPictureId;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getLogoPictureId() {
        return this.logoPictureId;
    }

    public void setLogoPictureId(String logoPictureId) {
        this.logoPictureId = logoPictureId;
    }

    public String getWelcomeInfo() {
        return this.welcomeInfo;
    }

    public void setWelcomeInfo(String welcomeInfo) {
        this.welcomeInfo = welcomeInfo;
    }

    public String getCopyrightInfo() {
        return this.copyrightInfo;
    }

    public void setCopyrightInfo(String copyrightInfo) {
        this.copyrightInfo = copyrightInfo;
    }

    public String getInputBoxColor() {
        return this.inputBoxColor;
    }

    public void setInputBoxColor(String inputBoxColor) {
        this.inputBoxColor = inputBoxColor;
    }

    public int getButtonPosition() {
        return this.buttonPosition;
    }

    public void setButtonPosition(int buttonPosition) {
        this.buttonPosition = buttonPosition;
    }

    public String getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(String buttonColor) {
        this.buttonColor = buttonColor;
    }

    public String getButtonTextColor() {
        return this.buttonTextColor;
    }

    public void setButtonTextColor(String buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
    }

    public boolean isAdEnable() {
        return this.adEnable;
    }

    public void setAdEnable(boolean adEnable) {
        this.adEnable = adEnable;
    }

    public int getAdPictureMode() {
        return this.adPictureMode;
    }

    public void setAdPictureMode(int adPictureMode) {
        this.adPictureMode = adPictureMode;
    }

    public List<String> getAdPictureIdList() {
        return this.adPictureIdList;
    }

    public void setAdPictureIdList(List<String> adPictureIdList) {
        this.adPictureIdList = adPictureIdList;
    }

    public int getAdDurationTime() {
        return this.adDurationTime;
    }

    public void setAdDurationTime(int adDurationTime) {
        this.adDurationTime = adDurationTime;
    }

    public int getAdPictureCarouselInterval() {
        return this.adPictureCarouselInterval;
    }

    public void setAdPictureCarouselInterval(int adPictureCarouselInterval) {
        this.adPictureCarouselInterval = adPictureCarouselInterval;
    }

    public boolean isAllowSkip() {
        return this.allowSkip;
    }

    public void setAllowSkip(boolean allowSkip) {
        this.allowSkip = allowSkip;
    }

    public String getTwilioSid() {
        return c.d(this.twilioSid);
    }

    public void setTwilioSid(String twilioSid) {
        this.twilioSid = c.c(twilioSid);
    }

    public String getTwilioAuthToken() {
        return c.d(this.twilioAuthToken);
    }

    public void setTwilioAuthToken(String authToken) {
        this.twilioAuthToken = c.c(authToken);
    }

    public String getPhoneNumber() {
        return c.d(this.phoneNumber);
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = c.c(phoneNumber);
    }

    public Integer getMaxUser() {
        return this.maxUser;
    }

    public void setMaxUser(Integer maxUser) {
        this.maxUser = maxUser;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public int getLogoPosition() {
        return this.logoPosition;
    }

    public void setLogoPosition(int logoPosition) {
        this.logoPosition = logoPosition;
    }

    public String getWelcomeColor() {
        return this.welcomeColor;
    }

    public void setWelcomeColor(String welcomeColor) {
        this.welcomeColor = welcomeColor;
    }

    public String getCopyrightColor() {
        return this.copyrightColor;
    }

    public void setCopyrightColor(String copyrightColor) {
        this.copyrightColor = copyrightColor;
    }

    public String getGwId() {
        return this.gwId;
    }

    public void setGwId(String gwId) {
        this.gwId = gwId;
    }

    public String getGwSecret() {
        return this.gwSecret;
    }

    public void setGwSecret(String gwSecret) {
        this.gwSecret = gwSecret;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public List<String> getSelectedSsid() {
        return this.selectedSsid;
    }

    public void setSelectedSsid(List<String> selectedSsid) {
        this.selectedSsid = selectedSsid;
    }

    public List<String> getAdPictureIdArray() {
        return this.adPictureIdArray;
    }

    public void setAdPictureIdArray(List<String> adPictureIdArray) {
        this.adPictureIdArray = adPictureIdArray;
    }

    public List<String> getFreeAuthPolicyIdList() {
        return this.freeAuthPolicyIdList;
    }

    public void setFreeAuthPolicyIdList(List<String> freeAuthPolicyIdList) {
        this.freeAuthPolicyIdList = freeAuthPolicyIdList;
    }

    public Boolean getHttpsRedirectEnable() {
        return this.httpsRedirectEnable;
    }

    public void setHttpsRedirectEnable(Boolean httpsRedirectEnable) {
        this.httpsRedirectEnable = httpsRedirectEnable;
    }

    @JsonIgnore
    public String getPlainTwilioSid() {
        return this.twilioSid;
    }

    @JsonIgnore
    public String getPlainTwilioAuthToken() {
        return this.twilioAuthToken;
    }

    @JsonIgnore
    public String getPlainPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String getPlainRadiusPassword() {
        return this.radiusPassword;
    }
}

